/******************************************************************************
 *
 * Copyright (c) 2003-2004 PalmSource, Inc. All rights reserved.
 *
 * File: stdarg.h
 *
 * Release: Palm OS Developer Suite 5 SDK (68K) 4.0
 *
 * Description:
 *
 *
 *****************************************************************************/


#ifndef __PALMSOURCE_CC_HDR_STDARG_H
#define __PALMSOURCE_CC_HDR_STDARG_H


/* Note: The actual implementation of va_start & va_arg is internal to the
   compiler: these definitions hook up the standard macros to the internal
   mechanism via the __va_funcx builtin. */


#ifdef __cplusplus
extern "C" {
namespace _PSI {
#endif
extern char *__va_funcx(int, void*, ...); /* expanded by compiler */
#ifdef __cplusplus
}
}
#endif

#ifdef __cplusplus
namespace std {
#define __PALMSOURCE_CC_VAFUNCX _PSI::__va_funcx
#else
#define __PALMSOURCE_CC_VAFUNCX __va_funcx
#endif

#define __PALMSOURCE_CC_EABI_STDARG

#ifdef __PALMSOURCE_CC_EABI_STDARG
typedef struct __va_list {
    void * __ap;
} va_list;

#define va_start(ap,N) (void)((ap).__ap = (void*)__PALMSOURCE_CC_VAFUNCX(2, (char *) &(N)))
#define va_arg(ap,T) (*((T*) __PALMSOURCE_CC_VAFUNCX(3, &((ap).__ap), ((T*)0))))
#define va_end(ap) ((void) 0)
#define va_copy(dst,src) ((dst).__ap = (src).__ap)
#else
typedef int * va_list[1];

#define va_start(ap,N) (void)(*(ap) = (void*)__PALMSOURCE_CC_VAFUNCX(2, (char *) &(N)))
#define va_arg(ap,T) (*((T*) __PALMSOURCE_CC_VAFUNCX(3, ap, ((T*)0))))
#define va_end(ap) ((void) 0)
#define va_copy(dst,src) ((dst)[0] = (src)[0])
#endif

 /* Note: va_copy is a C99 feature, and thus a non-standard extension for
    C++ and C90. */

#ifdef __cplusplus
} /* namespace std */
#endif /* __cplusplus */

#endif /* __PALMSOURCE_CC_HDR_STDARG_H */


#if defined(__cplusplus) && !defined(__PALMSOURCE_CC_HDR_STDARG_H_NO_HOIST)
using std::va_list;
#endif /* __cplusplus && !__PALMSOURCE_CC_HDR_STDARG_H_NO_HOIST */
